#pragma once
#include "Model.h"
#include "PointLight.h"

class Phone : public Model
{
	public:
		Phone();
		~Phone();

		//Overrides
		bool loadMTL(char* modelFilename, char* mtlFilename, int renderingShape = GL_TRIANGLES) override;
		void render(Vector3 position = Vector3(5.0f, 1.0f, -4.0f)) override;

		void SetLights(PointLight* one, PointLight* two);	//Sets the lights that affect the jukebox's shadow

	private:
		//Roof point lights
		PointLight* _PointOne;
		PointLight* _PointTwo;
};


